/*------------------------------------------------------------------------------*
 * File Name: stdio.h															*
 * Creation: CPY 3/1/2001														*
 * Purpose: Origin C header	for basic io functions								*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#ifndef _STDIO_H
#define _STDIO_H

#include <common.h> // must always include this
#include <string.h> // most likely you will also need strings

// basic internal functions
#pragma dll(@OK)

// Last updated by Sim 04-21-2007
//Comments last updated by DG on 3/7/05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:out_str_(global_function)
*/
int out_str(LPCSTR lpcstr);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:out_int_(global_function)
*/
int out_int(LPCSTR lpcstr, int nValue);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:out_double_(global_function)
*/
int out_double(LPCSTR lpcstr, double dbValue); 

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:printf_(global_function)
*/
int printf(LPCSTR lpcszFormat, ...);



#ifndef NO_ANSI_FILE


typedef		int  	FILE;
#define		EOF     (-1)

#pragma dll(msvcrt, system)

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fclose_(global_function)
*/
int 	fclose(FILE * stream);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fopen_(global_function)
*/
FILE*  	fopen(const char *	filename, const char *mode);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fputs_(global_function)
*/
int		fputs(const char *str, FILE *stream );

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fprintf_(global_function)
*/
int 	fprintf(FILE *stream, const char *format, ...);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fscanf_(global_function)
*/
int 	fscanf(FILE *stream, const char *format , ...);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:feof_(global_function)
*/
int		feof(FILE *stream );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ferror_(global_function)
*/
int		ferror(FILE *stream);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fflush_(global_function)
*/
int		fflush(FILE *stream);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fgetc_(global_function)
*/
int		fgetc(FILE *stream);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fgets_(global_function)
*/
char*	fgets(char *str, int nLen, FILE *stream);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fputc_(global_function)
*/
int		fputc(int c, FILE *stream);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fread_(global_function)
*/
size_t  fread(void *buffer, size_t size, size_t count, FILE *stream);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fseek_(global_function)
*/
int		fseek(FILE *stream, long offset, int origin);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ftell_(global_function)
*/
long	ftell(FILE *stream);

// Last updated by Sim 04-21-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fwrite_(global_function)
*/
size_t  fwrite(const void *buffer, size_t size, size_t count, FILE *stream);

#endif // NO_ANSI_FILE


#endif //_STDIO_H

